/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.jsondefs.JSONAnimationDefinition;
import minecrafttransportsimulator.rendering.DurationDelayClock;

public class AnimationSwitchbox {
    public final TransformationMatrix netMatrix = new TransformationMatrix();
    public final RotationMatrix rotation = new RotationMatrix();
    public final Point3D translation = new Point3D();
    public Point3D scale = new Point3D();
    public double lastVisibilityValue = 1.0;
    public DurationDelayClock lastVisibilityClock;
    protected final AEntityD_Definable<?> entity;
    private final String applyAfter;
    private final List<DurationDelayClock> clocks = new ArrayList<DurationDelayClock>();
    private final Point3D helperPoint = new Point3D();
    private final Point3D helperScalingVector = new Point3D();
    private final RotationMatrix helperRotationMatrix = new RotationMatrix();
    private final TransformationMatrix helperOffsetOperationMatrix = new TransformationMatrix();
    private boolean inhibitAnimations;
    private boolean switchboxEnabled;
    private long lastTickRun;
    private float lastPartialTickRun;

    public AnimationSwitchbox(AEntityD_Definable<?> entity, List<JSONAnimationDefinition> animations, String applyAfter) {
        this.entity = entity;
        this.applyAfter = applyAfter;
        for (JSONAnimationDefinition animation : animations) {
            this.clocks.add(new DurationDelayClock(animation));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean runSwitchbox(float partialTicks, boolean forceSameTick) {
        if (!forceSameTick && this.lastTickRun == this.entity.ticksExisted && this.lastPartialTickRun == partialTicks) {
            return this.switchboxEnabled;
        }
        this.lastTickRun = this.entity.ticksExisted;
        this.lastPartialTickRun = partialTicks;
        if (this.applyAfter != null) {
            AnimationSwitchbox switchbox = this.entity.animatedObjectSwitchboxes.get(this.applyAfter);
            if (switchbox == null) {
                throw new IllegalArgumentException("Was told to applyAfter the object " + this.applyAfter + " on " + this.entity + ", but there aren't any animations to applyAfter!");
            }
            if (!switchbox.runSwitchbox(partialTicks, forceSameTick)) {
                this.switchboxEnabled = false;
                return false;
            }
            this.translation.set(switchbox.translation);
            this.rotation.set(switchbox.rotation);
            this.scale.set(switchbox.scale);
            this.netMatrix.set(switchbox.netMatrix);
        } else {
            this.translation.set(0.0, 0.0, 0.0);
            this.rotation.setToZero();
            this.scale.set(1.0, 1.0, 1.0);
            this.netMatrix.resetTransforms();
        }
        this.inhibitAnimations = false;
        this.switchboxEnabled = true;
        Iterator<DurationDelayClock> iterator = this.clocks.iterator();
        block8: while (iterator.hasNext()) {
            DurationDelayClock clock = iterator.next();
            switch (clock.animation.animationType) {
                case TRANSLATION: {
                    if (this.inhibitAnimations) continue block8;
                    this.runTranslation(clock, partialTicks);
                    break;
                }
                case ROTATION: {
                    if (this.inhibitAnimations) continue block8;
                    this.runRotation(clock, partialTicks);
                    break;
                }
                case VISIBILITY: {
                    if (this.inhibitAnimations) continue block8;
                    this.lastVisibilityClock = clock;
                    this.lastVisibilityValue = this.entity.getAnimatedVariableValue(clock, 1.0, partialTicks);
                    if (!(this.lastVisibilityValue < clock.animation.clampMin) && !(this.lastVisibilityValue > clock.animation.clampMax)) continue block8;
                    this.switchboxEnabled = false;
                    return false;
                }
                case INHIBITOR: {
                    if (this.inhibitAnimations) continue block8;
                    double variableValue = this.entity.getAnimatedVariableValue(clock, 1.0, partialTicks);
                    if (!(variableValue >= clock.animation.clampMin) || !(variableValue <= clock.animation.clampMax)) continue block8;
                    this.inhibitAnimations = true;
                    break;
                }
                case ACTIVATOR: {
                    if (!this.inhibitAnimations) continue block8;
                    double variableValue = this.entity.getAnimatedVariableValue(clock, 1.0, partialTicks);
                    if (!(variableValue >= clock.animation.clampMin) || !(variableValue <= clock.animation.clampMax)) continue block8;
                    this.inhibitAnimations = false;
                    break;
                }
                case SCALING: {
                    if (this.inhibitAnimations) continue block8;
                    this.runScaling(clock, partialTicks);
                    continue block8;
                }
            }
        }
        return true;
    }

    public void runTranslation(DurationDelayClock clock, float partialTicks) {
        double variableValue = this.entity.getAnimatedVariableValue(clock, clock.animationAxisMagnitude, partialTicks);
        if (variableValue != 0.0) {
            this.helperPoint.set(clock.animationAxisNormalized).scale(variableValue);
            this.netMatrix.applyTranslation(this.helperPoint);
            this.translation.add(this.helperPoint);
        }
    }

    public void runRotation(DurationDelayClock clock, float partialTicks) {
        double variableValue = this.entity.getAnimatedVariableValue(clock, clock.animationAxisMagnitude, partialTicks);
        if (variableValue != 0.0) {
            this.helperRotationMatrix.setToAxisAngle(clock.animationAxisNormalized, variableValue);
            if (clock.animation.centerPoint.x != 0.0 || clock.animation.centerPoint.y != 0.0 || clock.animation.centerPoint.z != 0.0) {
                this.helperOffsetOperationMatrix.resetTransforms();
                this.helperOffsetOperationMatrix.setTranslation(clock.animation.centerPoint);
                this.helperOffsetOperationMatrix.applyRotation(this.helperRotationMatrix);
                this.helperOffsetOperationMatrix.applyInvertedTranslation(clock.animation.centerPoint);
                this.netMatrix.multiply(this.helperOffsetOperationMatrix);
                this.translation.add(this.helperOffsetOperationMatrix.m03, this.helperOffsetOperationMatrix.m13, this.helperOffsetOperationMatrix.m23);
            } else {
                this.netMatrix.applyRotation(this.helperRotationMatrix);
            }
            this.rotation.multiply(this.helperRotationMatrix);
        }
    }

    public void runScaling(DurationDelayClock clock, float partialTicks) {
        double variableValue = this.entity.getAnimatedVariableValue(clock, clock.animationAxisMagnitude, partialTicks);
        this.helperScalingVector.set(clock.animationAxisNormalized).scale(variableValue);
        if (this.helperScalingVector.x == 0.0) {
            this.helperScalingVector.x = 1.0;
        }
        if (this.helperScalingVector.y == 0.0) {
            this.helperScalingVector.y = 1.0;
        }
        if (this.helperScalingVector.z == 0.0) {
            this.helperScalingVector.z = 1.0;
        }
        if (clock.animation.centerPoint.x != 0.0 || clock.animation.centerPoint.y != 0.0 || clock.animation.centerPoint.z != 0.0) {
            this.helperOffsetOperationMatrix.resetTransforms();
            this.helperOffsetOperationMatrix.setTranslation(clock.animation.centerPoint);
            this.helperOffsetOperationMatrix.applyScaling(this.helperScalingVector);
            this.helperOffsetOperationMatrix.applyInvertedTranslation(clock.animation.centerPoint);
            this.netMatrix.multiply(this.helperOffsetOperationMatrix);
            this.scale.multiply(this.helperScalingVector);
        } else {
            this.netMatrix.applyScaling(this.helperScalingVector);
        }
    }
}

